﻿//////////////////////////////////////////////
// DdsPixelFormat.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkImages
#include "../../Enums/PixelFormat.h"

#include "../Enums/DdsPixelFlag.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkImages::dds
{
	class DdsPixelFormat final
	{
		public :

			// Functions
			// Encode
			void encodeInData (nkMemory::BufferView<unsigned char> data) const ;
			// Decode
			void decodeFromData (nkMemory::BufferView<unsigned char> data) ;

			// Getters
			PIXEL_FORMAT getFormat () const ;

		public :

			// Attributes
			unsigned int _size = 32u ;
			DDS_PIXEL_FLAG _flags = DDS_PIXEL_FLAG::DDS_PIXEL_FLAG_UNKNOWN ;
			unsigned char _fourCc [4] ;
			unsigned int _rgbBitCount = 0 ;
			unsigned int _ryBitMask = 0 ;
			unsigned int _guBitMask = 0 ;
			unsigned int _bvBitMask = 0 ;
			unsigned int _aBitMask = 0 ;
	} ;
}